// Globālie mainīgie, lai uzturētu hronometra stāvokli un laiku
let chronoInterval; // Intervala identifikators, kas atjaunina hronometru
let chronoStartTime; // Laiks, kad hronometrs tika sākts vai atsākts pēc pauzes
let isRunning = false; // Norāda, vai hronometrs darbojas
let isPaused = false; // Norāda, vai hronometrs ir apturēts
let lapStartTime; // Laiks, kad pēdējais aplis tika sākts
let totalElapsedTime = 0; // Kopējais pagājušais laiks, kopš hronometrs tika sākts
let lastLapTotalTime = 0; // Kopējais pagājušais laiks pēdējā apļa laikā

// Saglabājam pogas un tabulas elementus
const startLapButton = document.getElementById('start-lap-button');
const pauseButton = document.getElementById('pause-button');
const stopButton = document.getElementById('stop-button');
const deleteButton = document.getElementById('delete-button');
const chronoTable = document.getElementById('chrono-table').querySelector('tbody');
const chronoTableHead = document.getElementById('chrono-table').querySelector('thead');

// Funkcija, kas sāk vai reģistrē apli
function startChronometer() {
  if (!isRunning) {
    // Ja hronometrs nedarbojas, sāk jaunu laika skaitīšanu
    chronoStartTime = Date.now() - totalElapsedTime;
    lapStartTime = totalElapsedTime;
    chronoInterval = setInterval(updateChronometer, 10); // Atjauno hronometru katras 10 milisekundes
    startLapButton.textContent = 'Aplis';
    startLapButton.style.display = 'inline'; // Nodrošina, ka poga ir redzama
    pauseButton.style.display = 'inline';
    stopButton.style.display = 'inline';
    chronoTableHead.style.display = 'table-header-group'; // Parāda tabulas galveni
    isRunning = true;
    isPaused = false;
    logChronoAction('Sakts'); // Reģistrē darbību žurnālā
  } else {
    logLap(); // Ja hronometrs jau darbojas, reģistrē apli
  }
}

// Funkcija, kas aptur vai atsāk hronometru
function pauseChronometer() {
  if (isRunning) {
    if (isPaused) {
      // Ja hronometrs ir apturēts, atsāk darbību
      chronoStartTime = Date.now() - totalElapsedTime;
      chronoInterval = setInterval(updateChronometer, 10);
      pauseButton.textContent = 'Nopauzet';
      isPaused = false;
      logChronoAction('Atpauzets'); // Reģistrē darbību žurnālā
    } else {
      // Ja hronometrs darbojas, aptur darbību
      clearInterval(chronoInterval);
      totalElapsedTime = Date.now() - chronoStartTime;
      pauseButton.textContent = 'Atpauzet';
      isPaused = true;
      logChronoAction('Nopauzets'); // Reģistrē darbību žurnālā
    }
  }
}

// Funkcija, kas pilnīgi aptur hronometru un var saglabāt laiku
function stopChronometer() {
  if (isRunning || isPaused) {
    clearInterval(chronoInterval);
    let lapTime = totalElapsedTime - lastLapTotalTime;
    let totalStopTime = totalElapsedTime;
    if (isPaused) {
      // Ja hronometrs ir apturēts pauzē, pielāgo apli un kopējo apturēšanas laiku
      lapTime = totalElapsedTime - lastLapTotalTime; // Aprēķina apli kā kopējo laiku kopš pēdējā apla
      totalStopTime = totalElapsedTime - (Date.now() - chronoStartTime); // Aprēķina kopējo apturēšanas laiku
    }
    logChronoAction('Apturets', lapTime, totalStopTime); // Padod apli un kopējo apturēšanas laiku, lai reģistrētu darbību
    isRunning = false;
    isPaused = false;
    stopButton.textContent = 'Saglabat';
    startLapButton.style.display = 'none';
    pauseButton.style.display = 'none';
    deleteButton.style.display = 'inline'; // Parāda dzēšanas pogu
  } else if (stopButton.textContent === 'Saglabat') {
    saveChronoLog(); // Saglabā žurnālu
  }
}

// Funkcija, kas atiestata hronometru
function resetChronometer() {
  clearInterval(chronoInterval);
  chronoTable.innerHTML = '';
  totalElapsedTime = 0;
  lastLapTotalTime = 0;
  isRunning = false;
  isPaused = false;
  startLapButton.style.display = 'inline';
  startLapButton.textContent = 'Sakt';
  pauseButton.style.display = 'none';
  stopButton.style.display = 'none';
  deleteButton.style.display = 'none';
  stopButton.textContent = 'Stop';
  document.getElementById('clock').textContent = '00:00:00';
  chronoTableHead.style.display = 'none'; // Paslēpj tabulas galveni
}

// Funkcija, kas atjaunina hronometru rādītāju
function updateChronometer() {
  const now = Date.now();
  if (!isPaused) {
    totalElapsedTime = now - chronoStartTime;
  }
  const elapsed = formatTime(totalElapsedTime);
  document.getElementById('chronometer-display').textContent = elapsed; // Update the chronometer display
}

// Funkcija, kas reģistrē hronometra darbību žurnālā
function logChronoAction(action) {
  const row = chronoTable.insertRow(); // Izveido jaunu rindu tabulā
  const actionCell = row.insertCell(0);
  const dateCell = row.insertCell(1);
  const timeCell = row.insertCell(2);
  const lapTimeCell = row.insertCell(3);
  const totalTimeCell = row.insertCell(4);
  actionCell.textContent = action; // Ievieto darbību šūnā
  const currentDate = new Date();
  dateCell.textContent = currentDate.toLocaleDateString(); // Ievieto datumu šūnā
  timeCell.textContent = currentDate.toLocaleTimeString(); // Ievieto laiku šūnā

  if (action === 'Aplis') {
    // Ja darbība ir "Aplis", rēķina un ievieto apli
    const lapTime = totalElapsedTime - lastLapTotalTime;
    lapTimeCell.textContent = formatTime(lapTime);
    lastLapTotalTime = totalElapsedTime;
  } else if (action === 'Apturets') {
    // Ja darbība ir "Apturets", tikai rēķina un ievieto apli, bet ne maina pēdējo apli
    const lapTime = totalElapsedTime - lastLapTotalTime;
    lapTimeCell.textContent = formatTime(lapTime);
  }

  totalTimeCell.textContent = formatTime(totalElapsedTime); // Ievieto kopējo laiku šūnā
}

// Funkcija, kas reģistrē apli
function logLap() {
  logChronoAction('Aplis'); // Izsauc funkciju ar "Aplis" darbību
}

// Funkcija, kas saglabā hronometra žurnālu JSON failā
function saveChronoLog() {
  const rows = chronoTable.rows;
  const log = [];
  for (let i = 0; i < rows.length; i++) {
    const cells = rows[i].cells;
    log.push({
      action: cells[0].textContent,
      date: cells[1].textContent,
      time: cells[2].textContent,
      lapTime: cells[3].textContent,
      totalTime: cells[4].textContent
    });
  }
  const blob = new Blob([JSON.stringify(log, null, 2)], { type: 'application/json' });
  const url = URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.href = url;
  a.download = 'hronometra_tabula.json';
  document.body.appendChild(a);
  a.click();
  document.body.removeChild(a);
}

// Funkcija, kas formātē laiku (milisekundes uz mm:ss:ms)
function formatTime(ms) {
  const sign = ms < 0 ? '-' : ''; // Pievieno zīmi negatīviem laikiem
  const totalSeconds = Math.abs(Math.floor(ms / 1000)); // Absolūtā vērtība, lai apstrādātu negatīvus laikus
  const minutes = Math.floor(totalSeconds / 60);
  const seconds = totalSeconds % 60;
  const milliseconds = Math.abs(Math.floor((ms % 1000) / 10)); // Absolūtā vērtība un apstrāde milisekundēs
  return `${sign}${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}:${milliseconds.toString().padStart(2, '0')}`;
}

// Piekļūst pogām un pievieno klausītājus notikumiem
startLapButton.addEventListener('click', startChronometer);
pauseButton.addEventListener('click', pauseChronometer);
stopButton.addEventListener('click', stopChronometer);
deleteButton.addEventListener('click', resetChronometer);

// Sākotnējais stāvoklis
resetChronometer();
