let loggedInUser = null;
let intervalId;
let stopwatchIntervalId;
let stopwatchTime = 0;
let laps = [];
let actions = [];

function login() {
    const username = document.getElementById('username').value;
    if (username) {
        loggedInUser = username;
        document.querySelector('.login-container').style.display = 'none';
        document.querySelector('.clock-container').style.display = 'flex';
        document.querySelector('.stopwatch-container').style.display = 'block';
        document.getElementById('user-info').innerText = `Sveicināts, ${username}!`;
        updateClock();
        setInterval(updateClock, 1000);
    }
}

function updateClock() {
    const now = new Date();
    const hours = now.getHours().toString().padStart(2, '0');
    const minutes = now.getMinutes().toString().padStart(2, '0');
    const seconds = now.getSeconds().toString().padStart(2, '0');
    const timeElement = document.getElementById('time');
    timeElement.innerHTML = `<span style="color:${document.getElementById('hoursColor').value};">${hours}</span>:<span style="color:${document.getElementById('minutesColor').value};">${minutes}</span>:<span style="color:${document.getElementById('secondsColor').value};">${seconds}</span>`;
    timeElement.style.fontFamily = document.getElementById('fontSelect').value;
}

function startStopwatch() {
    stopwatchIntervalId = setInterval(updateStopwatch, 1000);
    document.getElementById('start-btn').disabled = true;
    document.getElementById('lap-btn').disabled = false;
    document.getElementById('pause-btn').disabled = false;
    document.getElementById('stop-btn').disabled = false;
    logAction('sākt');
}

function updateStopwatch() {
    stopwatchTime++;
    const hours = Math.floor(stopwatchTime / 3600).toString().padStart(2, '0');
    const minutes = Math.floor((stopwatchTime % 3600) / 60).toString().padStart(2, '0');
    const seconds = (stopwatchTime % 60).toString().padStart(2, '0');
    document.getElementById('stopwatch').innerText = `${hours}:${minutes}:${seconds}`;
}

function lapStopwatch() {
    laps.push(stopwatchTime);
    logAction('aplis', stopwatchTime);
}

function pauseStopwatch() {
    clearInterval(stopwatchIntervalId);
    document.getElementById('pause-btn').innerText = 'Atsākt';
    document.getElementById('pause-btn').onclick = resumeStopwatch;
    logAction('pauze');
}

function resumeStopwatch() {
    stopwatchIntervalId = setInterval(updateStopwatch, 1000);
    document.getElementById('pause-btn').innerText = 'Pauze';
    document.getElementById('pause-btn').onclick = pauseStopwatch;
    logAction('atsākt');
}

function stopStopwatch() {
    clearInterval(stopwatchIntervalId);
    document.getElementById('stop-btn').innerText = 'Saglabāt';
    document.getElementById('stop-btn').onclick = saveData;
    document.getElementById('reset-btn').disabled = false;
    logAction('stop');
}

function resetData() {
    stopwatchTime = 0;
    laps = [];
    actions = [];
    document.getElementById('stopwatch').innerText = '00:00:00';
    document.getElementById('results').innerHTML = '';
    document.getElementById('start-btn').disabled = false;
    document.getElementById('lap-btn').disabled = true;
    document.getElementById('pause-btn').disabled = true;
    document.getElementById('pause-btn').innerText = 'Pauze';
    document.getElementById('pause-btn').onclick = pauseStopwatch;
    document.getElementById('stop-btn').disabled = true;
    document.getElementById('stop-btn').innerText = 'Stop';
    document.getElementById('stop-btn').onclick = stopStopwatch;
    document.getElementById('reset-btn').disabled = true;
    logAction('dzēst');
}

function logAction(action, lapTime = null) {
    const now = new Date();
    const formattedTime = `${now.getFullYear()}-${(now.getMonth() + 1).toString().padStart(2, '0')}-${now.getDate().toString().padStart(2, '0')} ${now.getHours().toString().padStart(2, '0')}:${now.getMinutes().toString().padStart(2, '0')}:${now.getSeconds().toString().padStart(2, '0')}`;
    const color = getClockColors();
    actions.push({ action, time: formattedTime, lapTime, color });
    displayResults();
}

function getClockColors() {
    const hoursColor = document.getElementById('hoursColor').value;
    const minutesColor = document.getElementById('minutesColor').value;
    const secondsColor = document.getElementById('secondsColor').value;
    return { hoursColor, minutesColor, secondsColor };
}

function displayResults() {
    const resultsElement = document.getElementById('results');
    resultsElement.innerHTML = actions.map((action, index) => {
        const lapTime = action.lapTime !== null ? ` - Aplis: ${formatTime(action.lapTime)}` : '';
        const colorStyle = index % 2 === 0 ? 'background-color: #f8f9fa;' : 'background-color: #e9ecef;';
        return `<div style="${colorStyle}">${action.time} - ${action.action}${lapTime}</div>`;
    }).join('');
}

function formatTime(seconds) {
    const hours = Math.floor(seconds / 3600).toString().padStart(2, '0');
    const minutes = Math.floor((seconds % 3600) / 60).toString().padStart(2, '0');
    const remainingSeconds = (seconds % 60).toString().padStart(2, '0');
    return `${hours}:${minutes}:${remainingSeconds}`;
}

function saveData() {
    const data = {
        user: loggedInUser,
        laps: laps.map((time, index) => ({
            lap: index + 1,
            time: formatTime(time),
            color: actions[index] ? actions[index].color : null
        })),
        actions: actions
    };
    const dataStr = JSON.stringify(data, null, 2);
    const blob = new Blob([dataStr], { type: 'application/json' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = `${loggedInUser}_stopwatch_data.json`;
    a.click();
    URL.revokeObjectURL(url);
}

function updateClockSettings() {
    updateClockStyles();
    updateStopwatchStyles();
}
