let users = [];
let currentUser = null;
const wordleWords = ["apple", "bread", "crane", "drama", "eagle"];
let currentWord = "";
let currentRow = 0;

// Show registration form
document.getElementById('show-registration').addEventListener('click', function() {
    document.getElementById('login').style.display = 'none';
    document.getElementById('registration').style.display = 'block';
});

// Registration form handling
document.getElementById('registration-form').addEventListener('submit', function(event) {
    event.preventDefault();
    const username = document.getElementById('username').value;
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm-password').value;

    if (password !== confirmPassword) {
        alert('Paroles nesakrit!');
        return;
    }

    if (!/^(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/.test(password)) {
        alert('Parolei jabut vismaz 8 rakstzimem, ietverot vismaz vienu ciparu un vienu specialo simbolu.');
        return;
    }

    users.push({ username, password });
    alert('Registracija veiksmiga!');
    document.getElementById('registration').style.display = 'none';
    document.getElementById('login').style.display = 'block';
});

// Login form handling
document.getElementById('login-form').addEventListener('submit', function(event) {
    event.preventDefault();
    const username = document.getElementById('login-username').value;
    const password = document.getElementById('login-password').value;

    const user = users.find(user => user.username === username && user.password === password);
    if (user) {
        alert('Pieteikanas veiksmiga!');
        currentUser = user;
        document.getElementById('login').style.display = 'none';
        document.getElementById('wordle-game').style.display = 'block';
        startNewGame();
    } else {
        alert('Nepareizs lietotajvards vai parole!');
    }
});

// Start a new game
function startNewGame() {
    currentWord = wordleWords[Math.floor(Math.random() * wordleWords.length)];
    console.log(currentWord); // For debugging purposes, remove in production
    document.getElementById('game-board').innerHTML = "";
    document.getElementById('word-input').value = "";
    currentRow = 0;
    for (let i = 0; i < 30; i++) {
        const cell = document.createElement('div');
        document.getElementById('game-board').appendChild(cell);
    }
}

// Submit a word
function submitWord() {
    const word = document.getElementById('word-input').value.toLowerCase();
    if (word.length !== 5) {
        alert('Vardam jabut 5 burtiem!');
        return;
    }

    const board = document.getElementById('game-board');
    const row = Array.from(board.children).slice(currentRow * 5, currentRow * 5 + 5);

    let wordCount = {};
    for (let letter of currentWord) {
        if (wordCount[letter]) {
            wordCount[letter]++;
        } else {
            wordCount[letter] = 1;
        }
    }

    for (let i = 0; i < 5; i++) {
        const cell = row[i];
        cell.textContent = word[i];
        if (word[i] === currentWord[i]) {
            cell.classList.add('correct');
            wordCount[word[i]]--;
        }
    }

    for (let i = 0; i < 5; i++) {
        const cell = row[i];
        if (!cell.classList.contains('correct')) {
            if (currentWord.includes(word[i]) && wordCount[word[i]] > 0) {
                cell.classList.add('present');
                wordCount[word[i]]--;
            } else {
                cell.classList.add('absent');
            }
        }
    }

    if (word === currentWord) {
        alert('Apsveicam, jus uzminejat vardu!');
        document.getElementById('submit-word').disabled = true;
    } else {
        currentRow++;
        if (currentRow >= 6) {
            alert(`Jus zaudejat! Pareizais vards bija: ${currentWord}`);
            document.getElementById('submit-word').disabled = true;
        }
    }

    document.getElementById('word-input').value = '';
}

// Event listener for the submit button
document.getElementById('submit-word').addEventListener('click', submitWord);

// Allow submitting the word by pressing Enter
document.getElementById('word-input').addEventListener('keypress', function(event) {
    if (event.key === 'Enter') {
        submitWord();
    }
});

// New game button
document.getElementById('new-game').addEventListener('click', function() {
    document.getElementById('submit-word').disabled = false;
    startNewGame();
});

// Show profile edit form
document.getElementById('edit-profile').addEventListener('click', function() {
    document.getElementById('wordle-game').style.display = 'none';
    document.getElementById('profile-edit').style.display = 'block';
    document.getElementById('edit-username').value = currentUser.username;
    document.getElementById('edit-password').value = '';
    document.getElementById('edit-confirm-password').value = '';
});

// Profile edit form handling
document.getElementById('profile-edit-form').addEventListener('submit', function(event) {
    event.preventDefault();
    const username = document.getElementById('edit-username').value;
    const password = document.getElementById('edit-password').value;
    const confirmPassword = document.getElementById('edit-confirm-password').value;

    if (password !== confirmPassword) {
        alert('Paroles nesakrit!');
        return;
    }

    if (!/^(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/.test(password)) {
        alert('Parolei jabut vismaz 8 rakstzimem, ietverot vismaz vienu ciparu un vienu specialo simbolu.');
        return;
    }

    currentUser.username = username;
    currentUser.password = password;
    alert('Profila atjauninaana veiksmiga!');
    document.getElementById('profile-edit').style.display = 'none';
    document.getElementById('wordle-game').style.display = 'block';
});
