var events = {};
const currentDate = new Date();
let currentMonth = currentDate.getMonth();
let currentYear = currentDate.getFullYear();
var header;
var daysContainer;
var eventsContainer;
var selectedDateSpan;
var eventsList;
var eventInput;
document.addEventListener(
    "DOMContentLoaded",
    function () {
    // Initial setup
       header = document.getElementById("current-month");
       daysContainer = document.getElementById("days");
       eventsContainer = document.getElementById("events-container");
       selectedDateSpan = document.getElementById("selected-date");
       eventsList = document.getElementById("events-list");
       eventInput = document.getElementById("event-input");
    
        document.getElementById("prev-month").addEventListener(
            "click",
            prevMonth
        );
    
        document.getElementById("next-month").addEventListener(
            "click", 
            nextMonth
        );
    
        document.getElementById("add-event-btn").addEventListener(
            "click", 
            addEvents
        );

    updateCalendar();
    }
);

function updateCalendar() {
    fetch("php/show.php?year="+currentYear+"&month="+(currentMonth*1+1))
        .then(x => x.json())
        .then(y => function(y){
            events = y;
            alert(y[0].string);
        }
            );

    // Events data structure to store events for each date
    const firstDay = new Date(currentYear, currentMonth, 1);
    const lastDay = new Date(currentYear, currentMonth + 1, 0);
    
    header.textContent = `${getMonthName(currentMonth)} ${currentYear}`;
    
    // Clear days container
    daysContainer.innerHTML = "";
    
    // Add day headers
    const dayHeaders = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
    dayHeaders.forEach((day) => {
        const dayHeader = document.createElement("div");
        dayHeader.textContent = day;
        daysContainer.appendChild(dayHeader);
    });
    
    // Add days
    for (let i = 0; i < firstDay.getDay(); i++) {
        const emptyDay = document.createElement("div");
        emptyDay.classList.add("day", "empty");
        daysContainer.appendChild(emptyDay);
    }
    
    for (let day = 1; day <= lastDay.getDate(); day++) {
        const date = new Date(currentYear, currentMonth, day);
        const dayElement = document.createElement("div");
        dayElement.id=formatDate(new Date(currentYear, currentMonth,day+1));
        dayElement.textContent = day;
        dayElement.classList.add("day");
        dayElement.addEventListener(
            "click",
            showEvents
        );
        daysContainer.appendChild(dayElement);
    }
    
    if (currentMonth === 12) {
        currentMonth = 0;
        currentYear++;
    } else if (currentMonth === -1) {
        currentMonth = 11;
        currentYear--;
    }
}

function nextMonth() {
    currentMonth++;
      if (currentMonth === 12) {
        currentMonth = 0;
        currentYear++;
    }
    updateCalendar();
}

function prevMonth() {
    currentMonth--;
    if (currentMonth === -1) {
        currentMonth = 11;
        currentYear--;
    }
    updateCalendar();
}

function addEvents() {
    const eventText = eventInput.value.trim();
    if (eventText !== "") {
      const dateKey = selectedDateSpan.textContent;
      const eventsForDate = events[dateKey] || [];
      // Store the event data
      eventsForDate.push(eventText);
      events[dateKey] = eventsForDate;/// ievieto
      // Update the UI
      showEvents(new Date(dateKey));
      eventInput.value = "";
    }
}
function showEvents() {
    date=this.id.split("-");
    year=date[0];
    month=date[1];
    eventsList.innerHTML = "";
   fetch(`php/show.php?year=${date[0]}&month=${date[1]}&day=${date[2]}`)
        .then((x) => x.json())
        .then(events => function(events){
            alert(events.lenght);
            events.forEach((event) => {
                alert(event.date);
                const ev = document.createElement("li");
                ev.textContent = event.string;
                eventsList.appendChild(ev);
        });
        }
    );
    eventsContainer.style.display = "block";
}

function getMonthName(month) {
    const months = [
      "January", "February", "March",
      "April", "May", "June",
      "July", "August", "September",
      "October", "November", "December"
    ];
    return months[month];
}

function formatDate(date) {
    //const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    const options = {  year: 'numeric',month: 'numeric', day: 'numeric' };
    return date.toISOString().slice(0, 10);
}




