<?php
include 'db.php';
header('Content-Type: application/javascript');
session_start();

if (!isset($_SESSION['user_id'])) {
    echo 'window.location.href = "../login.html";';
    exit();
}

$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $pcName = isset($_POST['pc_name']) ? htmlspecialchars($_POST['pc_name']) : '';
    $cpu = isset($_POST['cpu']) ? htmlspecialchars($_POST['cpu']) : '';
    $gpu = isset($_POST['gpu']) ? htmlspecialchars($_POST['gpu']) : '';
    $ram = isset($_POST['ram']) ? htmlspecialchars($_POST['ram']) : '';
    $storage = isset($_POST['storage']) ? htmlspecialchars($_POST['storage']) : '';
    $motherboard = isset($_POST['motherboard']) ? htmlspecialchars($_POST['motherboard']) : '';
    $powerSupply = isset($_POST['power_supply']) ? htmlspecialchars($_POST['power_supply']) : '';
    $pcCase = isset($_POST['pc_case']) ? htmlspecialchars($_POST['pc_case']) : '';

    // Add validation and sanitization as needed for form fields

    // Check if components exist, and insert if not
    $cpuId = getComponentId('cpu', $cpu);
    $gpuId = getComponentId('gpu', $gpu);
    $ramId = getComponentId('ram', $ram);
    $storageId = getComponentId('storage', $storage);
    $motherboardId = getComponentId('motherboard', $motherboard);
    $powerSupplyId = getComponentId('power_supply', $powerSupply);
    $pcCaseId = getComponentId('pc_case', $pcCase);

    // Insert data into the database
    $stmt = $conn->prepare("INSERT INTO nig_pcs (user_id, pc_name, cpu_id, gpu_id, ram_id, storage_id, motherboard_id, power_supply_id, pc_case_id) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isiiiiiii", $user_id, $pcName, $cpuId, $gpuId, $ramId, $storageId, $motherboardId, $powerSupplyId, $pcCaseId);

    if ($stmt->execute()) {
        // Redirect to main.html after a successful insertion
        echo 'window.location.href = "main.html";';
        exit();  // Ensure that no further code is executed after the redirect
    } else {
        // Handle error, e.g., send an error response
        echo 'console.error("Error adding PC: ' . $stmt->error . '");';
        exit();
    }

    $stmt->close();
}

$conn->close();

function getComponentId($table, $name) {
    global $conn;

    $stmt = $conn->prepare("SELECT id FROM nig_$table WHERE name = ?");
    $stmt->bind_param("s", $name);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['id'];
    }

    // If the component doesn't exist, insert and return the new ID
    $stmt = $conn->prepare("INSERT INTO nig_$table (name) VALUES (?)");
    $stmt->bind_param("s", $name);
    $stmt->execute();

    return $stmt->insert_id;
}
?>
