<?php
session_start();
include 'db.php';

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.html");
    exit();
}

$user_id = $_SESSION['user_id'];

// Fetch user's PCs from the database
$sql = "SELECT pc_name, nig_cpu.name as cpu_name, nig_gpu.name as gpu_name, nig_ram.name as ram_name, 
               nig_storage.name as storage_name, nig_motherboard.name as motherboard_name, 
               nig_power_supply.name as power_supply_name, nig_pc_case.name as pc_case_name
        FROM nig_pcs
        INNER JOIN nig_cpu ON nig_pcs.cpu_id = nig_cpu.id
        INNER JOIN nig_gpu ON nig_pcs.gpu_id = nig_gpu.id
        INNER JOIN nig_ram ON nig_pcs.ram_id = nig_ram.id
        INNER JOIN nig_storage ON nig_pcs.storage_id = nig_storage.id
        INNER JOIN nig_motherboard ON nig_pcs.motherboard_id = nig_motherboard.id
        INNER JOIN nig_power_supply ON nig_pcs.power_supply_id = nig_power_supply.id
        INNER JOIN nig_pc_case ON nig_pcs.pc_case_id = nig_pc_case.id
        WHERE nig_pcs.user_id = $user_id";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    echo "<table border='1'>
            <tr>
                <th>PC Name</th>
                <th>CPU</th>
                <th>GPU</th>
                <th>RAM</th>
                <th>Storage</th>
                <th>Motherboard</th>
                <th>Power Supply</th>
                <th>PC Case</th>
            </tr>";

    while ($row = $result->fetch_assoc()) {
        echo "<tr>
                <td>{$row['pc_name']}</td>
                <td>{$row['cpu_name']}</td>
                <td>{$row['gpu_name']}</td>
                <td>{$row['ram_name']}</td>
                <td>{$row['storage_name']}</td>
                <td>{$row['motherboard_name']}</td>
                <td>{$row['power_supply_name']}</td>
                <td>{$row['pc_case_name']}</td>
              </tr>";
    }

    echo "</table>";
} else {
    echo "No PCs found for the user.";
}

$conn->close();
?>
