<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "markuss_luksafori";

// Create connection
$conn = mysqli_connect($servername, $username, $password, $dbname);
// Check connection
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}
$conn->set_charset("utf8");
// SQL query to join tables and select the needed data
$query = "SELECT 
            o.name, 
            p.cycle, 
            p.red_amber, 
            p.amber, 
            p.pedestrians_flash, 
            pr.type, 
            pr.direct, 
            pr.green_offset, 
            pr.green_len 
          FROM 
            object o
          JOIN 
            plan p ON o.id = p.id_obj
          JOIN 
            program pr ON p.id = pr.id_plan;";

$result = mysqli_query($conn, $query);

// Initialize the arrays to hold our data
$trafficCycles = [];
$programData = [];

// Fetch the data and split into two arrays
while ($row = mysqli_fetch_assoc($result)) {
    $trafficCycles[] = [
        'name' => $row['name'],
        'cycle' => $row['cycle'],
        'red_amber' => $row['red_amber'],
        'amber' => $row['amber'],
        'pedestrians_flash' => $row['pedestrians_flash']
    ];
    
    // Assuming there are multiple program rows for each plan
    $programData[] = [
        'type' => $row['type'],
        'direct' => $row['direct'],
        'green_offset' => $row['green_offset'],
        'green_len' => $row['green_len']
    ];
}

// Combine the arrays
$json_data = json_encode([
    'trafficCycles' => $trafficCycles,
    'programData' => $programData
]);

// Close the database connection
mysqli_close($conn);

// Return the JSON data
header('Content-Type: application/json');
echo $json_data;
?>