<?php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newUsername = isset($_POST['newUsername']) ? htmlspecialchars($_POST['newUsername']) : '';
    $newPassword = isset($_POST['newPassword']) ? htmlspecialchars($_POST['newPassword']) : '';

    try {
        $checkExistingUser = "SELECT id FROM bk_users WHERE username = ?";
        $stmt = $conn->prepare($checkExistingUser);
        $stmt->bind_param('s', $newUsername);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            echo "Error: This username is already taken. Please choose a different one.";
            header("Refresh: 2; URL=register.html");
        } else {
            $sql = "INSERT INTO bk_users (username, password) VALUES (?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('ss', $newUsername, $newPassword);

            if ($stmt->execute()) {
                echo "Registration successful. Redirecting to login page...";
                header("Refresh: 2; URL=../html/index.html");
                exit();
            } else {
                echo "Error: " . $stmt->error;
            }
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    } finally {
        $stmt->close();
        $conn->close();
    }
}
?>
