<?php
if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"));
    $username = isset($data->username) ? htmlspecialchars($data->username) : '';
    $password = isset($data->password) ? htmlspecialchars($data->password) : '';

    include 'db.php';

    try {
        $sql = "SELECT id FROM bk_users WHERE username = ? AND password = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('ss', $username, $password);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $stmt->bind_result($user_id);
            $stmt->fetch();
            session_start();
            $_SESSION['user_id'] = $user_id;
            echo json_encode(['success' => true, 'message' => 'Login successful']);
        } else {
            http_response_code(401); // Unauthorized
            echo json_encode(['error' => 'Invalid username or password']);
        }
    } catch (Exception $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['error' => 'Error: ' . $e->getMessage()]);
    } finally {
        $stmt->close();
        $conn->close();
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Invalid request method']);
}
?>
