<?php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';

    // Validate and sanitize the input
    $taskId = isset($_POST['taskId']) ? htmlspecialchars($_POST['taskId']) : '';

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("DELETE FROM bk_tasks WHERE user_id = ? AND id = ?");
    $stmt->bind_param("ss", $user_id, $taskId);

    if ($stmt->execute()) {
        echo "Task deleted successfully";
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close the prepared statement
    $stmt->close();
}
?>
