<?php
// Check if the request is a GET request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';
    
    // Validate and sanitize the input
    $taskDate = isset($_GET['date']) ? htmlspecialchars($_GET['date']) : '';
    
    include 'db.php';
    include "inc/dayTask.php";
    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $user_id, $taskDate);
    $stmt->execute();

    $result = $stmt->get_result();
    $tasks =  $result->fetch_all(MYSQLI_ASSOC);
     
    // Return tasks as JSON
    header('Content-Type: application/json');
    echo json_encode($tasks);

    // Close the prepared statement
    $stmt->close();
}
?>

