<?php

// Check if the request is a GET request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';
    
    // Validate and sanitize the input
    $taskmonth = isset($_GET['month']) ? htmlspecialchars($_GET['month']) : '';
    $taskyear = isset($_GET['year']) ? $_GET['year'] : '';
    
    include 'db.php';
    include "inc/monthTask.php";
    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iii", $user_id, $taskmonth,$taskyear);
    $stmt->execute();
    $tasks= $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
 
     // Return tasks as JSON
    header('Content-Type: application/json');
    echo json_encode($tasks);

    // Close the prepared statement
    $stmt->close();
}
?>
