<?php
// Check if the request is a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';
    $eventText = isset($_POST['eventText']) ? htmlspecialchars($_POST['eventText']) : '';
    $taskDate = isset($_POST['date']) ? htmlspecialchars($_POST['date']) : '';
    $detailText = isset($_POST['detailText']) ? htmlspecialchars($_POST['detailText']) : '';

    include 'db.php';
    include 'inc/insertTask.php';
    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iss", $user_id, $eventText, $taskDate);

    if ($stmt->execute()) {
        // Get the ID of the inserted task
        $taskId = $conn->insert_id;

        // Insert task details into the 'bk_task_details' table
        include 'inc/insertDetail.php';
        $stmtDetails = $conn->prepare($sql);
        $stmtDetails->bind_param("is", $taskId, $detailText);

        if ($stmtDetails->execute()) {
            echo "Event and details added successfully";
        } else {
            echo "Error adding details: " . $stmtDetails->error;
        }

        $stmtDetails->close();
    } else {
        echo "Error adding event: " . $stmt->error;
    }

    $stmt->close();
}
?>