var currentYear;
var currentMonth;

document.addEventListener('DOMContentLoaded', function () {
    // Get the current date
    const currentDate = new Date();

    // Initialize current month
    currentYear = currentDate.getFullYear();
    currentMonth = currentDate.getMonth() + 1;

    // Generate the initial calendar
    generateCalendar(currentYear, currentMonth);

    // Add event listeners to next and previous buttons
    document.getElementById('prevBtn').addEventListener('click', function () {
        changeMonth(-1);
    });

    document.getElementById('nextBtn').addEventListener('click', function () {
        changeMonth(1);
    });
});

function generateCalendar(year, month) {
    const calendarDiv = document.getElementById('calendarbody');
	document.getElementById('cal_title').innerHTML= `${getMonthName(month)} ${year}`;
    let calendarHTML ="";
    const daysInMonth = new Date(year, month, 0).getDate();
    const firstDayOfWeek = new Date(year, month - 1, 1).getDay();

    let dayCounter = 1;

    for (let i = 0; i < 6; i++) {
        calendarHTML += '<tr>';

        for (let j = 0; j < 7; j++) {
            if ((i === 0 && j < firstDayOfWeek) || dayCounter > daysInMonth) {
                calendarHTML += '<td></td>';
            } else {
                // Check if there are tasks for the day
               // const hasTasks = await checkTasksForDay(year, month, dayCounter);

                calendarHTML += `<td id="${handleDate(year, month, dayCounter)}" onclick="handleDateClick(this)">${dayCounter}</td>`;
                dayCounter++;
            }
        }

        calendarHTML += `\t\t</tr>\n`;
    }

     calendarDiv.innerHTML = calendarHTML;
	 updateCalendar(year, month);
}
function updateCalendar(year, month) {
    fetch(`php/allTask.php?month=${encodeURIComponent(month)}&year=${encodeURIComponent(year)}`)
		.then((response) => response.json())
		.then((data)=>{
            let td=document.getElementById('calendarbody').querySelectorAll("td");
        	td.forEach(el => {
                data.forEach(task =>{
            		if( task.task_date==el.id){
		            	let element=document.getElementById(el.id);
            			element.classList.remove("green");
            			element.classList.remove("red");
            			element.classList.add(task.completed? 'green' : 'red');
            		}
            	});
		    });
		});
}

function getMonthName(month) {
    const months = [
        'January', 'February', 'March', 'April',
        'May', 'June', 'July', 'August',
        'September', 'October', 'November', 'December'
    ];
    return months[month - 1];
}

function handleDate(year, month, day) {
    return `${year}-${month < 10 ? '0' + month : month}-${day < 10 ? '0' + day : day}`;
}

function handleDateClick(element) {
    const dateStr = element.id;

    // Create a popup element
    const popup = document.createElement('div');
    popup.className = 'popup';
    popup.innerHTML = `
        <div class="popup-content">
            <p id="popupDate">You clicked on ${dateStr}</p>
            <label for="eventInput">Event:</label>
            <input type="text" id="eventInput" placeholder="Enter event...">
            <label for="detailInput">Details:</label>
            <input type="text" id="detailInput" placeholder="Enter task details...">
            <button class="add-btn" onclick="addEvent('${dateStr}')">Add</button>
            <table id="taskTable">
                <thead>
                    <tr>
                        <th>Task</th>
                        <th>Details</th>
                        <th>Completed</th>
                        <th>Delete</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            <button class="close-btn" onclick="closePopup()">Close</button>
        </div>
    `;
    document.body.appendChild(popup);

    // Fetch tasks for the clicked date and populate the table
    fetchTasks(dateStr);

    // Add animation class for sliding in
    setTimeout(() => {
        popup.classList.add('slide-in');
    }, 10);
}



function fetchTasks(dateStr) {
    const taskTableBody = document.querySelector('#taskTable tbody');
    const popupDateElement = document.getElementById('popupDate');

	fetch(`php/getTasks.php?date=${encodeURIComponent(dateStr)}`)
		.then((response) => response.json())
		.then((data)=>{
				const allCompleted = data.every(task => task.completed);
				popupDateElement.style.backgroundColor = allCompleted ? 'green' : 'red';

				// Clear the existing table rows
            taskTableBody.innerHTML = '';

            // Populate the table with tasks and details
			HTML="";
            data.forEach(task => {
                HTML += `
                <tr>
					<td>${task.task_text}</td>
                    <td>${task.detail_text}</td>
                    <td><input type="checkbox" ${task.completed ? 'checked' : ''} onclick="updateTaskStatus(${task.id}, this.checked)"></td>
                    <td><button onclick="deleteTask(${task.id})">Delete</button></td>
				</tr>
                `;
            });
				taskTableBody.innerHTML =HTML;
        });
}


function closePopup() {
    const popup = document.querySelector('.popup');

    // Add animation class for sliding out
    popup.classList.remove('slide-in');
    
    // Remove the popup element from the DOM after the animation completes
    setTimeout(() => {
        document.body.removeChild(popup);
    }, 300);
}

function changeMonth(delta) {
    currentMonth += delta;

    if (currentMonth < 1) {
        currentMonth = 12;
        currentYear--;
    } else if (currentMonth > 12) {
        currentMonth = 1;
        currentYear++;
    }

    generateCalendar(currentYear, currentMonth);
}

function addEvent(dateStr) {
    let fd=new FormData();
    fd.set('eventText',encodeURIComponent(document.getElementById('eventInput').value.trim()));
    fd.set('detailTex',encodeURIComponent(document.getElementById('detailInput').value.trim()));
    fd.set('date',encodeURIComponent(dateStr));
    fetch('php/updateTaskStatus.php',{
        method: "POST",
        body: fd
    })
.then((response) => response.text())
.then((res)=> {
 if (res !== '') {
                // Clear the input fields
                document.getElementById('eventInput').value = '';
                document.getElementById('detailInput').value = '';

                // Close the popup
               // closePopup();

                // Refresh the calendar or update as needed
                 alert (currentMonth);
                updateCalendar(currentYear, currentMonth);
            }
        });
}


function updateTaskStatus(taskId, completed) {
    let fd=new FormData();
    fd.set('taskId', encodeURIComponent(taskId) );
    fd.set('completed', encodeURIComponent(completed ? 1 : 0) );
    fetch('php/updateTaskStatus.php',{
        method: "POST",
        body: fd
    })
.then((response) => response.text())
.then((res)=> {
         alert (currentMonth);
    
    // Update the UI based on the response
        const checkbox = document.querySelector(`#taskTable input[data-task-id="${taskId}"]`);
        if (checkbox) {
            checkbox.checked = completed;
        }
                        alert (currentMonth);
                updateCalendar(currentYear, currentMonth);

    });
    
}

async function checkTasksForDay(year, month, day) {
    const dateStr = `${year}-${month < 10 ? '0' + month : month}-${day < 10 ? '0' + day : day}`;
    const url = `php/getTasks.php?date=${encodeURIComponent(dateStr)}`;

    try {
        const response = await fetch(url);
        if (response.ok) {
            const tasks = await response.json();

            // Return true if there are tasks, false otherwise
            return tasks.length > 0;
        } else {
            console.error('Failed to fetch tasks:', response.status, response.statusText);
            return false;
        }
    } catch (error) {
        console.error('Error fetching tasks:', error);
        return false;
    }
}

async function areAllTasksCompleted(year, month, day) {
    const dateStr = `${year}-${month < 10 ? '0' + month : month}-${day < 10 ? '0' + day : day}`;
    const url = `php/getTasks.php?date=${encodeURIComponent(dateStr)}`;

    try {
        const response = await fetch(url);
        if (response.ok) {
            const tasks = await response.json();

            // Check if all tasks are completed
            return tasks.every(task => task.completed);
        } else {
            console.error('Failed to fetch tasks:', response.status, response.statusText);
            return false;
        }
    } catch (error) {
        console.error('Error fetching tasks:', error);
        return false;
    }
}
function deleteTask(taskId) {
    const confirmDelete = confirm("Are you sure you want to delete this task?");

    if (confirmDelete) {
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'php/deleteTask.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    // Display the response (you can customize this part)
                    alert(xhr.responseText);

                    // Reload the page after deleting the task
                    location.reload();
                } else {
                    // Handle error scenarios here
                    alert('Error deleting task');
                }
            }
        };

        // Send the POST request with the task ID to delete
        xhr.send(`taskId=${encodeURIComponent(taskId)}`);
    }
}
