<?php

function handleUpdateTaskStatus() {
    // Retrieve data from the request
    $requestData = json_decode(file_get_contents('php://input'), true);

    // Extract data from the request
    $taskId = $requestData['taskId'];
    $completed = $requestData['completed'];

    include 'db.php';

    session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("UPDATE bk_tasks SET completed = ? WHERE id = ? AND user_id = ?");
    $stmt->bind_param("sss", $completed, $taskId, $user_id);
    $stmt->execute();

    // Check if the update was successful
    if ($stmt->affected_rows > 0) {
        // Respond with success status
        header('Content-Type: application/json');
        echo json_encode(array("success" => true));
    } else {
        // Respond with error status
        header('Content-Type: application/json');
        echo json_encode(array("success" => false, "message" => "Error updating task status"));
    }

    // Close the prepared statement and the database connection
    $stmt->close();
    $conn->close();
}

?>
