<?php

function handleRegister() {
    // Retrieve data from the request
    $requestData = json_decode(file_get_contents('php://input'), true);

	include 'db.php';
	
	session_start();
    // Retrieve username and password from the request
    $username = $requestData['username'];
    $password = $requestData['password'];

    // Use prepared statements to prevent SQL injection
    $sql = "INSERT INTO bk_users (username, password) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $username, $password);

    // Execute the prepared statement
    $success = $stmt->execute();

    // Close the prepared statement and the database connection
    $stmt->close();
    $conn->close();

    // Return the response as JSON
    header('Content-Type: application/json');
    echo json_encode(array("success" => $success));
}

?>
