<?php

function handleLogin() {
    // Retrieve data from the request
    $requestData = json_decode(file_get_contents('php://input'), true);

    include 'db.php';
	
    session_start();

    // Retrieve username and password from the request
    $username = $requestData['username'];
    $password = $requestData['password'];

    // Use prepared statements to prevent SQL injection
    $sql = "SELECT * FROM bk_users WHERE username=? AND password=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $username, $password);

    // Execute the prepared statement
    $stmt->execute();

    // Get the result
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // User authenticated successfully
        $response = array("success" => true);

        // Get the user ID and store it in the session
        $userData = $result->fetch_assoc();
        $_SESSION['user_id'] = $userData['id'];
    } else {
        // Authentication failed
        $response = array("success" => false);
    }

    // Close the prepared statement and the database connection
    $stmt->close();
    $conn->close();

    // Return the response as JSON
    header('Content-Type: application/json');
    echo json_encode($response);
}

?>
