<?php

function handleGetTasks() {
    // Validate and sanitize the input
    $date = isset($_GET['date']) ? htmlspecialchars($_GET['date']) : '';

    include 'db.php';

    session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("SELECT t.*, td.detail_text FROM bk_tasks t LEFT JOIN bk_task_details td ON t.id = td.task_id WHERE t.user_id = ? AND t.task_date = ?");
    $stmt->bind_param("ss", $user_id, $date);
    $stmt->execute();

    $result = $stmt->get_result();
    $tasks = array();

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $tasks[] = $row;
        }
    }

    // Return tasks as JSON
    header('Content-Type: application/json');
    echo json_encode($tasks);

    // Close the prepared statement and the database connection
    $stmt->close();
    $conn->close();
}

?>
