<?php

function handleDeleteTask() {
    // Retrieve data from the request
    $requestData = json_decode(file_get_contents('php://input'), true);

    include 'db.php';

    session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';
    $taskId = isset($_GET['taskId']) ? htmlspecialchars($_GET['taskId']) : '';

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("DELETE FROM bk_tasks WHERE user_id = ? AND id = ?");
    $stmt->bind_param("ss", $user_id, $taskId);

    if ($stmt->execute()) {
        // Respond with success message if needed
        header('Content-Type: application/json');
        echo json_encode(array("message" => "Task deleted successfully"));
    } else {
        // Respond with error message if needed
        header('Content-Type: application/json');
        echo json_encode(array("message" => "Error deleting task: " . $stmt->error));
    }

    // Close the prepared statement
    $stmt->close();
}

?>
