<?php

function handleAddEvent() {
    // Start the session
    session_start();

    // Check if the user is logged in
    if (!isset($_SESSION['user_id'])) {
        // If not logged in, respond with an error status
        header('Content-Type: application/json');
        echo json_encode(array("success" => false, "error" => "User not authenticated"));
        exit;  // Ensure no additional content is sent after the JSON response
    }

    // Retrieve data from the request
    $requestData = json_decode(file_get_contents('php://input'), true);

    // Extract data from the request
    $eventText = $requestData['eventText'];
    $detailText = $requestData['detailText'];
    $timeText = $requestData['timeText'];
    $date = $requestData['date'];

    include 'db.php';

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("INSERT INTO bk_tasks (user_id, task_text, task_date, task_time) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $_SESSION['user_id'], $eventText, $date, $timeText); // Updated line

    if ($stmt->execute()) {
        // Get the ID of the inserted task
        $taskId = $conn->insert_id;

        // Insert task details into the 'bk_task_details' table
        $stmtDetails = $conn->prepare("INSERT INTO bk_task_details (task_id, detail_text) VALUES (?, ?)");
        $stmtDetails->bind_param("ss", $taskId, $detailText);

        // Execute the details insertion without checking for success
        $stmtDetails->execute();
        $stmtDetails->close();

        // Respond with a simple success status
        header('Content-Type: application/json');
        echo json_encode(array("success" => true));
    } else {
        // Respond with a simple error status
        header('Content-Type: application/json');
        echo json_encode(array("success" => false, "error" => "Error adding event: " . $stmt->error));
    }

    $stmt->close();
}

?>
