<?php

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

    // Handle different POST cases based on URI
    switch ($uri) {
        case '/users/api/login':
            include '../php/login.php';
            handleLogin();
            break;

        case '/users/api/register':
            include '../php/register.php';
            handleRegister();
            break;

        case '/users/api/addevent':
            include '../php/addevent.php';
            handleAddEvent();
            break;

        case '/users/api/updateTaskStatus': // New case for updating task status
            include '../php/updateTaskStatus.php';
            handleUpdateTaskStatus();
            break;

        default:
            // Handle unknown URI
            header('HTTP/1.1 404 Not Found');
            echo 'Not Found';
            break;
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

    // Handle different GET cases based on URI
    switch ($uri) {
        case '/users/api/logout':
            include '../php/logout.php';
            handleLogout();
            break;

        case '/users/api/getTasks':
            include '../php/getTasks.php';
            handleGetTasks();
            break;
		
        default:
            // Handle unknown URI
            header('HTTP/1.1 404 Not Found');
            echo 'Not Found';
            break;
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    // Handle delete for DELETE requests
    include '../php/delete.php';
    handleDeleteTask();
} else {
    // Handle other HTTP methods if necessary
    header('HTTP/1.1 405 Method Not Allowed');
    header('Allow: POST, GET, DELETE');
    echo 'Method Not Allowed';
}

?>
