let currentYear;
let currentMonth;

document.addEventListener('DOMContentLoaded', function () {
    const currentDate = new Date();

    currentYear = currentDate.getFullYear();
    currentMonth = currentDate.getMonth() + 1;

    generateCalendar(currentYear, currentMonth);

    document.getElementById('prevBtn').addEventListener('click', function () {
        changeMonth(-1);
    });

    document.getElementById('nextBtn').addEventListener('click', function () {
        changeMonth(1);
    });
});

function generateCalendar(year, month) {
    const calendarDiv = document.getElementById('calendar');
    let calendarHTML = '';

    calendarHTML += `<h2>${getMonthName(month)} ${year}</h2>`;
    calendarHTML += '<table>';
    calendarHTML += '<tr><th>Sun</th><th>Mon</th><th>Tue</th><th>Wed</th><th>Thu</th><th>Fri</th><th>Sat</th></tr>';

    const daysInMonth = new Date(year, month, 0).getDate();
    const firstDayOfWeek = new Date(year, month - 1, 1).getDay();

    let dayCounter = 1;

    for (let i = 0; i < 6; i++) {
        calendarHTML += '<tr>';

        for (let j = 0; j < 7; j++) {
            if ((i === 0 && j < firstDayOfWeek) || dayCounter > daysInMonth) {
                calendarHTML += '<td></td>';
            } else {
                calendarHTML += `<td onclick="handleDateClick(${year}, ${month}, ${dayCounter})">${dayCounter}</td>`;
                dayCounter++;
            }
        }

        calendarHTML += '</tr>';
    }

    calendarHTML += '</table>';
    calendarDiv.innerHTML = calendarHTML;
}

function getMonthName(month) {
    const months = [
        'January', 'February', 'March', 'April',
        'May', 'June', 'July', 'August',
        'September', 'October', 'November', 'December'
    ];

    return months[month - 1];
}

function handleDateClick(year, month, day) {
    const dateStr = `${year}-${month < 10 ? '0' + month : month}-${day < 10 ? '0' + day : day}`;

    const popup = document.createElement('div');
    popup.className = 'popup';
    popup.innerHTML = `
        <div class="popup-content">
            <p id="popupDate">You clicked on ${dateStr}</p>
            <label for="eventInput">Event:</label>
            <input type="text" id="eventInput" placeholder="Enter event...">
            <button class="add-btn" onclick="addEvent('${dateStr}')">Add</button>
            <table id="taskTable">
                <thead>
                    <tr>
                        <th>Task</th>
                        <th>Completed</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            <button class="close-btn" onclick="closePopup()">Close</button>
        </div>
    `;
    document.body.appendChild(popup);

    fetchTasks(dateStr);

    setTimeout(() => {
        popup.classList.add('slide-in');
    }, 10);
}

function fetchTasks(dateStr) {
    const taskTableBody = document.querySelector('#taskTable tbody');
    const popupDateElement = document.getElementById('popupDate');

    const xhr = new XMLHttpRequest();
    xhr.open('GET', `getTasks.php?date=${encodeURIComponent(dateStr)}`, true);

    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4 && xhr.status === 200) {
            const tasks = JSON.parse(xhr.responseText);

            const allCompleted = tasks.every(task => task.completed);

            popupDateElement.style.backgroundColor = allCompleted ? 'green' : 'red';

            tasks.forEach(task => {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${task.task_text}</td>
                    <td><input type="checkbox" ${task.completed ? 'checked' : ''} onclick="updateTaskStatus(${task.id}, this.checked)"></td>
                    <td>${task.task_date}</td>
                `;
                taskTableBody.appendChild(row);
            });
        }
    };

    xhr.send();
}
function closePopup() {
    const popup = document.querySelector('.popup');

    popup.classList.remove('slide-in');
    
    setTimeout(() => {
        document.body.removeChild(popup);
    }, 300);
}

function changeMonth(delta) {
    currentMonth += delta;

    if (currentMonth < 1) {
        currentMonth = 12;
        currentYear--;
    } else if (currentMonth > 12) {
        currentMonth = 1;
        currentYear++;
    }

    generateCalendar(currentYear, currentMonth);
}
function addEvent(dateStr) {
    const eventInput = document.getElementById('eventInput');
    const eventText = eventInput.value.trim();

    if (eventText !== '') {
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'addEvent.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                alert(xhr.responseText);
                
                eventInput.value = '';
                
                closePopup();
            }
        };

        xhr.send(`eventText=${encodeURIComponent(eventText)}&date=${encodeURIComponent(dateStr)}`);
    }
}
function updateTaskStatus(taskId, completed) {
    const xhr = new XMLHttpRequest();
    xhr.open('POST', 'updateTaskStatus.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4) {
            if (xhr.status === 200) {
                alert(xhr.responseText);

                const checkbox = document.querySelector(`#taskTable input[data-task-id="${taskId}"]`);
                if (checkbox) {
                    checkbox.checked = completed;
                }
            } else {
                alert('Error updating task status');
            }
        }
    };

    xhr.send(`taskId=${encodeURIComponent(taskId)}&completed=${encodeURIComponent(completed ? 1 : 0)}`);
}
