<?php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	session_start();
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '';
    $eventText = isset($_POST['eventText']) ? htmlspecialchars($_POST['eventText']) : '';
    $taskDate = isset($_POST['date']) ? htmlspecialchars($_POST['date']) : '';

    $stmt = $conn->prepare("INSERT INTO tasks (user_id, task_text, task_date) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $user_id, $eventText, $taskDate);

    if ($stmt->execute()) {
        echo "Event added successfully";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
}
?>
