function submitForm() {
    console.log("Form submitted!");
    const vin = document.getElementById('vin').value; // Get VIN for search

    // Check if VIN is provided for search
    if (vin) {
        // Call function to search for car by VIN
        searchByVIN(vin);
    } else {
        // If VIN is not provided, proceed with car registration
        registerCar();
    }
}

function searchByVIN(vin) {
    // Perform a fetch request to search for the car by VIN
    fetch(`search.php?vin=${vin}`, {
        method: 'GET',
    })
        .then(response => response.json())
        .then(data => {
            console.log(data);
            if (data.message === 'Car found') {
                alert('Car found! Displaying car details...');
                // Display or process the found car details as needed
            } else {
                alert('Car not found. Proceed with registration.');
                // If car not found, proceed with registration
                registerCar();
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function registerCar() {
    // Continue with the existing registration logic
    const make = document.getElementById('make').value;
    const model = document.getElementById('model').value;
    const year = document.getElementById('year').value;
    const color = document.getElementById('color').value;
    const vin = document.getElementById('vin').value;

    const formData = new FormData();
    formData.append('make', make);
    formData.append('model', model);
    formData.append('year', year);
    formData.append('color', color);
    formData.append('vin', vin);

    fetch('register.php', {
        method: 'POST',
        body: formData
    })
        .then(response => response.json())
        .then(data => {
            console.log(data);
            alert(data.message);
            document.getElementById('registrationForm').reset();
        })
        .catch(error => {
            console.error('Error:', error);
        });
}
