document.addEventListener("DOMContentLoaded", function () {
    fetchProductInfo();
});

function fetchProductInfo() {
    // Fetch product data from the server
    fetch('php/get_products.php')
        .then(response => response.json())
        .then(data => {
            // Render products in the HTML
            renderProducts(data);
        })
        .catch(error => console.error('Error fetching product data:', error));
}

function renderProducts(products) {
    const productsContainer = document.getElementById('products-container');

    products.forEach(product => {
        const productElement = createProductElement(product);
        productsContainer.appendChild(productElement);
    });
}

function createProductElement(product) {
    const productElement = document.createElement('div');
    productElement.classList.add('product');

    productElement.innerHTML = `
        <img src="img/${product.id}.jpg" alt="${product.product_name}">
        <h3>${product.product_name}</h3>
        <p>$${product.price}</p>
        <p>${product.description}</p>
        <button class="add-to-cart" onclick="openCartModal(${product.id})">Add to Cart</button>
    `;

    return productElement;
}

function openCartModal(productId) {
    const modal = document.getElementById('cart-modal');
    const amountInput = document.getElementById('amountInput');

    // Set the product ID in a data attribute for later use
    amountInput.setAttribute('data-product-id', productId);

    modal.style.display = 'block';
}

function closeCartModal() {
    const modal = document.getElementById('cart-modal');
    modal.style.display = 'none';
}

function addToCartWithAmount() {
    const productId = document.getElementById('amountInput').getAttribute('data-product-id');
    const amount = document.getElementById('amountInput').value;

    // Insert the product into the cart with the chosen amount
    fetch('php/add_to_cart.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ productId, amount }),
    })
    .then(response => response.json())
    .then(data => {
        console.log('Product added to cart:', data);
        closeCartModal();
    })
    .catch(error => console.error('Error adding to cart:', error));
}

// Close the modal if the user clicks outside of it
window.onclick = function (event) {
    const modal = document.getElementById('cart-modal');
    if (event.target === modal) {
        closeCartModal();
    }
}
