document.addEventListener("DOMContentLoaded", function () {
    fetchCartItems();
});

function fetchCartItems() {
    // Fetch cart items from the server
    fetch('php/get_cart_items.php')
        .then(response => response.json())
        .then(data => {
            // Render cart items in the HTML
            renderCartItems(data);
        })
        .catch(error => console.error('Error fetching cart items:', error));
}

function renderCartItems(cartItems) {
    const cartItemsContainer = document.getElementById('cart-items');

    if (cartItems.length === 0) {
        cartItemsContainer.innerHTML = '<p>Your cart is empty.</p>';
    } else {
        cartItems.forEach(cartItem => {
            const cartItemElement = createCartItemElement(cartItem);
            cartItemsContainer.appendChild(cartItemElement);
        });
    }
}

function createCartItemElement(cartItem) {
    const cartItemElement = document.createElement('div');
    cartItemElement.classList.add('cart-item');

    cartItemElement.innerHTML = `
        <img src="${cartItem.product_id}.jpg" alt="${cartItem.product_name}">
        <div>
            <h3>${cartItem.product_name}</h3>
            <p>Price: $${cartItem.price}</p>
            <p>Quantity: ${cartItem.amount}</p>
        </div>
    `;

    return cartItemElement;
}
