var blockSize = 20;
var total_row = 25;
var total_col = 25;
var board;
var context;

var snakeX = blockSize * 5;
var snakeY = blockSize * 5;

var speedX = 0;
var speedY = 0;

var snakeBody = [];

var foodX;
var foodY;

var score = 0;
var userHighscore = 0;

var gameOver = false;
var gameInterval; // Declare the game interval variable

window.onload = function () {
    board = document.getElementById("board");
    board.height = total_row * blockSize;
    board.width = total_col * blockSize;
    context = board.getContext("2d");

    placeFood();
    fetchUserHighscore();
    document.addEventListener("keyup", changeDirection);
    gameInterval = setInterval(update, 1000 / 10); // Assign the interval to the gameInterval variable
}

function fetchUserHighscore() {
    fetch('get_highscore.php')
        .then(response => response.json())
        .then(data => {
            userHighscore = data.highscore;
        })
        .catch(error => console.error('Error fetching highscore:', error));
}

function update() {
    if (gameOver) {
        displayGameOver();
        clearInterval(gameInterval); // Clear the interval
        return;
    }

    context.fillStyle = "green";
    context.fillRect(0, 0, board.width, board.height);

    context.fillStyle = "yellow";
    context.fillRect(foodX, foodY, blockSize, blockSize);

    context.fillStyle = "white";
    context.font = "20px Arial";
    context.fillText("Score: " + score + " | Highscore: " + userHighscore, 10, 20);

    if (snakeX == foodX && snakeY == foodY) {
        score++;
        updateHighscore(score);
        snakeBody.push([foodX, foodY]);
        placeFood();
    }

    for (let i = snakeBody.length - 1; i > 0; i--) {
        snakeBody[i] = snakeBody[i - 1];
    }
    if (snakeBody.length) {
        snakeBody[0] = [snakeX, snakeY];
    }

    context.fillStyle = "white";
    snakeX += speedX * blockSize;
    snakeY += speedY * blockSize;
    context.fillRect(snakeX, snakeY, blockSize, blockSize);
    for (let i = 0; i < snakeBody.length; i++) {
        context.fillRect(snakeBody[i][0], snakeBody[i][1], blockSize, blockSize);
    }

    if (snakeX < 0 || snakeX > total_col * blockSize || snakeY < 0 || snakeY > total_row * blockSize) {
        gameOver = true;
        displayGameOver();
    }

    for (let i = 0; i < snakeBody.length; i++) {
        if (snakeX == snakeBody[i][0] && snakeY == snakeBody[i][1]) {
            gameOver = true;
            displayGameOver();
        }
    }
}

function changeDirection(e) {
    if (e.code == "ArrowUp" && speedY != 1) {
        speedX = 0;
        speedY = -1;
    } else if (e.code == "ArrowDown" && speedY != -1) {
        speedX = 0;
        speedY = 1;
    } else if (e.code == "ArrowLeft" && speedX != 1) {
        speedX = -1;
        speedY = 0;
    } else if (e.code == "ArrowRight" && speedX != -1) {
        speedX = 1;
        speedY = 0;
    }
}

function placeFood() {
    foodX = Math.floor(Math.random() * total_col) * blockSize;
    foodY = Math.floor(Math.random() * total_row) * blockSize;
}

function updateHighscore(score) {
    fetch('update_highscore.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'score=' + score,
    })
        .then(response => response.text())
        .then(data => {
            const response = JSON.parse(data);
            if (response.updated) {
                fetchUserHighscore();
            }
        })
        .catch(error => console.error('Error updating highscore:', error));
}

function displayGameOver() {
    // Display game over message
    context.fillStyle = "red";
    context.font = "30px Arial";
    context.fillText("Game Over", board.width / 2 - 80, board.height / 2 - 15);

    // Display score and highscore
    context.fillStyle = "white";
    context.font = "20px Arial";
    context.fillText("Your Score: " + score, board.width / 2 - 70, board.height / 2 + 20);
    context.fillText("Highscore: " + userHighscore, board.width / 2 - 70, board.height / 2 + 50);

    // Create and display restart button
    restartButton.addEventListener("click", restartGame);
    document.body.appendChild(restartButton);
}

function restartGame() {
    // Reset game variables
    gameOver = false;
    snakeX = blockSize * 5;
    snakeY = blockSize * 5;
    speedX = 0;
    speedY = 0;
    snakeBody = [];
    score = 0;
    placeFood();

    // Restart the game interval
    gameInterval = setInterval(update, 1000 / 10);

}