document.addEventListener("DOMContentLoaded", function () {
    fetchTasks();
});

function fetchTasks() {
    // Dabū datus no mysql datubazes izmantojot php
    fetch('php/get_tasks.php')
        .then(response => response.json())
        .then(data => displayTasks(data));
}

//Izvade
function displayTasks(tasks) {

    const tableBody = document.getElementById('tasksTableBody');
    tableBody.innerHTML = '';

    // Izvada katru rindu
    tasks.forEach(task => {
        const row = `
            <tr>
                <td>${task.id}</td>
                <td>${task.task_name}</td>
                <td>${task.task_status}</td>
                <td>
                    <button class="btn btn-primary" onclick="openEditModal(${task.id}, '${task.task_name}', '${task.task_status}')">Edit</button>
                    <button class="btn btn-danger" onclick="deleteTask(${task.id})">Delete</button>
                </td>
            </tr>
        `;
        tableBody.innerHTML += row;
    });
}

//atver logo datu Edit
function openEditModal(taskId, taskName, taskStatus) {
    document.getElementById('editTaskName').value = taskName;
    document.getElementById('editTaskStatus').value = taskStatus;

    $('#editTaskModal').modal('show');
    window.currentEditingTaskId = taskId;
}

//Izmainit status vai task name
function updateTask() {
    const updatedTaskName = document.getElementById('editTaskName').value;
    const updatedTaskStatus = document.getElementById('editTaskStatus').value;

    fetch('php/update_task.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            taskId: window.currentEditingTaskId,
            taskName: updatedTaskName,
            taskStatus: updatedTaskStatus,
        }),
    })
    .then(response => response.json())
    .then(data => {
        $('#editTaskModal').modal('hide');
        fetchTasks();
    });
}

//Izdzest task
function deleteTask(taskId) {

    fetch('php/delete_task.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            taskId: taskId,
        }),
    })
    .then(response => response.json())
    .then(data => {

        fetchTasks();
    });
}

//Pievienot task
function addTask() {
    const newTaskName = document.getElementById('addTaskName').value;
    const newTaskStatus = document.getElementById('addTaskStatus').value;

    fetch('php/add_task.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            taskName: newTaskName,
            taskStatus: newTaskStatus,
        }),
    })
    .then(response => response.json())
    .then(data => {
        $('#addTaskModal').modal('hide');
        fetchTasks();
    });
}

//Datu ieguve
function fetchTasks(sortType = 'all') {
    fetch('php/get_tasks.php?sort=' + sortType)
        .then(response => response.json())
        .then(data => displayTasks(data));
}

//Filtresana
function sortTasks() {
    const sortType = document.getElementById('sortTasks').value;
    fetchTasks(sortType);
}

