<?php
include "conn.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get user input from the registration form
    $username = $_POST["username"];
    $password = $_POST["password"]; // Store the password as typed
    $email = $_POST["email"];

    // Validate user input (you may want to add more validation)
    if (empty($username) || empty($password) || empty($email)) {
        echo "Please fill in all fields.";
    } else {
        // Check if the email or username already exists in Davids_reg
        $checkSql = "SELECT * FROM ".$pref."reg WHERE username = ? OR email = ?";
        $checkStatement = $conn->prepare($checkSql);
        $checkStatement->bind_param("ss", $username, $email);
        $checkStatement->execute();
        $checkResult = $checkStatement->get_result();

        if ($checkResult->num_rows > 0) {
            echo "Username or email already exists. Please choose different credentials.";
        } else {
            // Insert the new user into the Davids_reg database
            $insertSql = "INSERT INTO ".$pref."reg (username, password, email) VALUES (?, ?, ?)";
            $insertStatement = $conn->prepare($insertSql);
            $insertStatement->bind_param("sss", $username, $password, $email);

            if ($insertStatement->execute()) {
                echo "Registration successful!";
            } else {
                echo "Error: " . $insertSql . "<br>" . $conn->error;
            }
        }
    }

    $checkStatement->close();
}

// Close the database connection
$conn->close();
?>
