<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    include "conn.php";

    // Retrieve data from the form
    $carName = $_POST["carName"];
    $carType = $_POST["carType"];
    $carPrice = $_POST["carPrice"];

    // SQL query using prepared statement and bind parameters
    $sql = "INSERT INTO ".$pref."Inventory (carName, carType, carPrice) VALUES (?, ?, ?)";
    
    $stmt = $conn->prepare($sql);

    // Bind parameters
    $stmt->bind_param("sss", $carName, $carType, $carPrice);

    if ($stmt->execute()) {
        // Close the prepared statement
        $stmt->close();

        // Close the database connection before redirecting
        $conn->close();

        // Redirect to inventory.php
        header("Location: ../inventory.php");
        exit(); // Make sure to exit after sending the header
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close the prepared statement and the database connection
    $stmt->close();
    $conn->close();
}
?>
