<?php
include "conn.php";

// Check if the form for removing a car is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["removeCar"])) {
    $carIdToRemove = $_POST["removeCar"];

    
    $removeSql = "DELETE FROM ".$pref."Inventory WHERE id = ?";
    
    $stmt = $conn->prepare($removeSql);
    
   
    $stmt->bind_param("i", $carIdToRemove);

    if ($stmt->execute()) {
        echo "Car removed successfully";
    } else {
        echo "Error removing car: " . $stmt->error;
    }

    $stmt->close();
}

$sql = "SELECT id, carType, carName, carPrice FROM Davids_Inventory";
$result = $conn->query($sql);

if (!$result) {
    echo "Error fetching data: " . $conn->error;
} else {
    if ($result->num_rows > 0) {
        echo "<h2>Current Inventory</h2>";
        echo "<ul>";
        while ($row = $result->fetch_assoc()) {
            echo "<li>{$row['carType']} - {$row['carName']} - {$row['carPrice']}";

            // Add a form and button for removing the car
            echo "<form method='post' action=''>";
            echo "<input type='hidden' name='removeCar' value='{$row['id']}'>";
            echo "<button type='submit' style='color: red;'>Remove</button>";
            echo "</form>";

            echo "</li>";
        }
        echo "</ul>";
    } else {
        echo "<p>No items in the inventory yet.</p>";
    }
}

$conn->close();
?>
